'**********************************************************
'*      WRITE DATA TO REGISTER OF R2000-R27777            *
'**********************************************************
BEGIN:      
        WIDTH 80, 25: CLS 2
        PRINT "** Press Ctrl+C To Escape the Programe **"
        COLOR 4: LOCATE 4, 20: PRINT "** WRITE TO SG-8 DATA MEMORY **": COLOR 7: PRINT
REINPUT:    
        LOCATE 6, 10: INPUT "  WRITE REGISTER NO. (2000-2777) ? ", DTN: PRINT
        IF (DTN \ 1000) < 2 THEN GOTO REINPUT
        IF (DTN \ 1000) > 2 THEN GOTO REINPUT

        LOCATE 8, 10: INPUT "  WRITE DATA (0000-FFFF) ?  ", RGDT$: PRINT : RGERR = 0
        FOR I = 1 TO 4
                RGDT$(I) = MID$(RGDT$, I, 1)
        NEXT I
        FOR J = 1 TO 4
                RGDT(J) = ASC(RGDT$(J))
                IF RGDT(J) < 48 THEN RGERR = 1
                IF RGDT(J) < 58 THEN RGDT(J) = RGDT(J) - 48: GOTO JNEXT
                IF RGDT(J) < 65 THEN RGERR = 1
                IF RGDT(J) > 70 THEN RGERR = 1
                RGDT(J) = RGDT(J) - 55
JNEXT:
        NEXT J

        IF RGERR = 1 THEN GOTO REINPUT

' 2000-2777 REFERENCE NO.CONVERSION
        DTNO = DTN - 2000
        IF (DTNO \ 100) = 1 THEN GOTO NODATA1
        IF (DTNO \ 100) = 2 THEN GOTO NODATA2
        IF (DTNO \ 100) = 3 THEN GOTO NODATA3
        IF (DTNO \ 100) = 4 THEN GOTO NODATA4
        IF (DTNO \ 100) = 5 THEN GOTO NODATA5
        IF (DTNO \ 100) = 6 THEN GOTO NODATA6
        IF (DTNO \ 100) = 7 THEN GOTO NODATA7
        NO = ((DTNO \ 10) * 8 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA1:      
        NO = ((DTNO \ 10) * 8 - 16 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA2:
        NO = ((DTNO \ 10) * 8 - 32 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA3:
        NO = ((DTNO \ 10) * 8 - 48 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA4:
        NO = ((DTNO \ 10) * 8 - 64 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA5:
        NO = ((DTNO \ 10) * 8 - 80 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA6:      
        NO = ((DTNO \ 10) * 8 - 96 + (DTNO MOD 10)) + 1025: GOTO HEADER
NODATA7:
        NO = ((DTNO \ 10) * 8 - 112 + (DTNO MOD 10)) + 1025: GOTO HEADER
'
'
HEADER:
        SH$ = CHR$(&H1)
        UT$ = CHR$(&H30) + CHR$(&H31)
        RW$ = CHR$(&H38)
        FC$ = CHR$(&H31)
        GOSUB MKHEAD
'
        DT1$ = LEFT$(RGDT$, 2)
        DT2$ = RIGHT$(RGDT$, 2)
        DT$ = DT2$ + DT1$
        CT = 4
        GOSUB LRCAL
        DT$ = CHR$(&H2) + DT$ + CHR$(&H3) + LRC$
        GOTO COMBEG

'*********  MAKE HEADER & LRC  *************
'
MKHEAD:
        AD$ = HEX$(NO): ADL = LEN(AD$)
        IF ADL = 1 THEN AD$ = CHR$(&H30) + CHR$(&H30) + CHR$(&H30) + AD$
        IF ADL = 2 THEN AD$ = CHR$(&H30) + CHR$(&H30) + AD$
        IF ADL = 3 THEN AD$ = CHR$(&H30) + AD$
        BT$ = CHR$(&H30) + CHR$(&H30) + CHR$(&H30) + CHR$(&H34)
        MT$ = CHR$(&H30) + CHR$(&H31)
        ETB$ = CHR$(&H17)
        LRC$ = UT$ + RW$ + FC$ + AD$ + BT$ + MT$
        LRC = ASC(LEFT$(LRC$, 1)): CT = LEN(LRC$)
        FOR I = 1 TO CT - 1
                LRC = LRC XOR ASC(MID$(LRC$, I + 1, 1))
        NEXT
        LRC$ = HEX$(LRC): LRCL = LEN(LRC$)
        IF LRCL = 1 THEN LRC$ = CHR$(&H30) + LRC$
        HD$ = SH$ + UT$ + RW$ + FC$ + AD$ + BT$ + MT$ + ETB$ + LRC$
        RETURN

'
'**********  DATA LRC CALCULATION  ***************
LRCAL:
        LRC = ASC(LEFT$(DT$, 1)): CT = LEN(DT$)
        FOR I = 1 TO CT - 1
                LRC = LRC XOR ASC(MID$(DT$, I + 1, I))
        NEXT
        LRC$ = HEX$(LRC): LRCL = LEN(LRC$)
        IF LRCL = 1 THEN LRC$ = CHR$(&H30) + LRC$
        RETURN
'**********  BEGIN COMMOUNICATION  ****************
COMBEG:
        LOCATE 10, 5: PRINT "*** BEGIN COMMUNICATION  *** ": PRINT
        CLOSE
        OPEN "COM2:9600,N,8,1" FOR RANDOM AS #1
        A$ = "N" + CHR$(&H21) + CHR$(&H5)
        PRINT #1, A$
        INPUT #1, B$
        LOCATE 12, 10: PRINT "* HEADER "; HD$: PRINT
        PRINT #1, HD$
        INPUT #1, C$
        LOCATE 14, 10: PRINT "* REGISTER *"; DTN; " * DATA* "; RGDT$: PRINT
        PRINT #1, DT$
        INPUT #1, C$
        E$ = CHR$(&H4)
        PRINT #1, E$
        CLOSE
        LOCATE 16, 5: PRINT " *** END OF COMMUNICATION *** ": PRINT
        GOTO REINPUT

